<?php $__env->startSection('title', __('inventory.title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold text-[var(--color-sap-text-dark)]">
            <i class="fas fa-boxes mr-2"></i> <?php echo e(__('inventory.title')); ?>

        </h2>
        <div class="flex gap-2 flex-wrap">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.view')): ?>
                <a href="<?php echo e(route('inventory.export')); ?>?<?php echo e(request()->getQueryString()); ?>"
                   class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-700 transition-colors text-sm">
                    <i class="fas fa-file-excel mr-2"></i> <?php echo e(__('inventory.buttons.export_excel')); ?>

                </a>
                <a href="<?php echo e(route('inventory.export-grouped')); ?>?<?php echo e(request()->getQueryString()); ?>"
                   class="inline-flex items-center px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition-colors text-sm">
                    <i class="fas fa-file-excel mr-2"></i> <?php echo e(__('inventory.buttons.export_grouped')); ?>

                </a>
                <button type="button" id="export-brand-btn"
                        class="inline-flex items-center px-4 py-2 bg-yellow-500 text-white rounded hover:bg-yellow-600 transition-colors text-sm">
                    <i class="fas fa-file-excel mr-2"></i> Exportar por Marca
                </button>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.create')): ?>
                <a href="<?php echo e(route('inventory.create')); ?>"
                   class="inline-flex items-center px-4 py-2 bg-[var(--color-sap-blue-light)] text-white rounded hover:bg-[var(--color-sap-blue-hover)] transition-colors text-sm">
                    <i class="fas fa-plus mr-2"></i> <?php echo e(__('inventory.buttons.add_item')); ?>

                </a>
            <?php endif; ?>
        </div>
    </div>

    <p class="mb-4 text-gray-600"><?php echo e(__('inventory.description')); ?></p>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow-[var(--shadow-light)] mb-4">
        <div class="px-6 py-4 border-b border-gray-200">
            <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
                <i class="fas fa-filter mr-2"></i> <?php echo e(__('inventory.filters.title')); ?>

            </h5>
        </div>
        <div class="p-6">
            <form id="search-form" class="row g-3">
                <div class="col-md-2">
                    <label for="search_barcode" class="form-label"><?php echo e(__('inventory.filters.barcode')); ?></label>
                    <input type="text" class="form-control" id="search_barcode"
                        placeholder="<?php echo e(__('inventory.filters.barcode_placeholder')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="search_mocaco" class="form-label"><?php echo e(__('inventory.filters.mocaco')); ?></label>
                    <input type="text" class="form-control" id="search_mocaco"
                        placeholder="<?php echo e(__('inventory.filters.mocaco_placeholder')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="search_n_carton" class="form-label"><?php echo e(__('inventory.filters.box_number')); ?></label>
                    <input type="text" class="form-control" id="search_n_carton"
                        placeholder="<?php echo e(__('inventory.filters.box_number_placeholder')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="search_ubicacion" class="form-label"><?php echo e(__('inventory.filters.location')); ?></label>
                    <input type="text" class="form-control" id="search_ubicacion"
                        placeholder="<?php echo e(__('inventory.filters.location_placeholder')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="search_containers" class="form-label">Container</label>
                    <div class="multiselect-wrapper">
                        <button type="button" class="form-control multiselect-button" id="search_containers_btn">
                            <span class="multiselect-text">Seleccionar...</span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="multiselect-dropdown" id="search_containers_dropdown" style="display: none;">
                            <div class="multiselect-header">
                                <button type="button" class="btn btn-sm btn-link" id="containers_select_all">Seleccionar Todos</button>
                                <button type="button" class="btn btn-sm btn-link" id="containers_clear">Limpiar</button>
                            </div>
                            <div class="multiselect-search">
                                <input type="text" class="form-control form-control-sm" id="containers_search_input" placeholder="Buscar container...">
                            </div>
                            <div class="multiselect-options" id="search_containers_options">
                                <div class="text-muted text-center p-2">Cargando...</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                    <label for="search_seasons" class="form-label">Internal Season</label>
                    <div class="multiselect-wrapper">
                        <button type="button" class="form-control multiselect-button" id="search_seasons_btn">
                            <span class="multiselect-text">Seleccionar...</span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="multiselect-dropdown" id="search_seasons_dropdown" style="display: none;">
                            <div class="multiselect-header">
                                <button type="button" class="btn btn-sm btn-link" id="seasons_select_all">Seleccionar Todos</button>
                                <button type="button" class="btn btn-sm btn-link" id="seasons_clear">Limpiar</button>
                            </div>
                            <div class="multiselect-search">
                                <input type="text" class="form-control form-control-sm" id="seasons_search_input" placeholder="Buscar temporada...">
                            </div>
                            <div class="multiselect-options" id="search_seasons_options">
                                <div class="text-muted text-center p-2">Cargando...</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                    <label for="search_marcas" class="form-label"><?php echo e(__('inventory.filters.brand')); ?></label>
                    <input type="text" class="form-control" id="search_marcas"
                        placeholder="<?php echo e(__('inventory.filters.brand_placeholder')); ?>">
                </div>
                <div class="col-md-2">
                    <div class="form-check mt-4">
                        <input class="form-check-input" type="checkbox" id="search_needs_review" value="1">
                        <label class="form-check-label" for="search_needs_review">
                            <i class="fas fa-exclamation-circle text-warning"></i> Solo "Sin Info"
                        </label>
                    </div>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search"></i> <?php echo e(__('inventory.filters.search_button')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>

    <div id="search_message" class="hidden mb-4 p-4 rounded"></div>

    <!-- Controles de Paginación -->
    <div class="bg-white rounded-lg shadow-[var(--shadow-light)] mb-4">
        <div class="p-4">
            <div class="flex justify-between items-center flex-wrap gap-3">
                <div class="flex items-center gap-2">
                    <label for="items_per_page" class="text-sm text-gray-700"><?php echo e(__('inventory.pagination.rows_per_page')); ?></label>
                    <select id="items_per_page" class="px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-[var(--color-sap-blue-light)] text-sm">
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50" selected>50</option>
                        <option value="100">100</option>
                        <option value="250">250</option>
                    </select>
                </div>
                <div id="pagination_info" class="text-sm text-gray-500"></div>
                <div class="flex items-center gap-2">
                    <button id="prev_page_btn"
                            class="px-3 py-1 text-sm bg-gray-200 text-gray-700 rounded hover:bg-gray-300 disabled:opacity-50 disabled:cursor-not-allowed"
                            disabled><?php echo e(__('inventory.pagination.previous')); ?></button>
                    <span id="page_numbers"></span>
                    <button id="next_page_btn"
                            class="px-3 py-1 text-sm bg-gray-200 text-gray-700 rounded hover:bg-gray-300 disabled:opacity-50 disabled:cursor-not-allowed"
                            disabled><?php echo e(__('inventory.pagination.next')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de Resultados -->
    <div class="bg-white rounded-lg shadow-[var(--shadow-light)]">
        <div class="px-6 py-4 border-b border-gray-200">
            <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
                <i class="fas fa-list mr-2"></i> <?php echo e(__('inventory.results.title')); ?>

            </h5>
        </div>
        <div class="p-0">
            <div id="inventory_search_results">
                <p class="text-center text-gray-500 p-8"><?php echo e(__('inventory.results.initial_message')); ?></p>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmación de Eliminación -->
    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-70 z-50 flex justify-center items-center" style="display: none;">
        <div class="bg-white p-6 rounded-lg max-w-md w-11/12 shadow-xl">
            <h3 class="text-xl font-semibold mb-4 text-gray-900"><?php echo e(__('inventory.modal.delete_title')); ?></h3>
            <div class="flex justify-end gap-2">
                <button id="cancel_delete"
                        class="px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-700 transition-colors text-sm">
                    <?php echo e(__('inventory.modal.cancel')); ?>

                </button>
                <button id="confirm_delete"
                        class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700 transition-colors text-sm">
                    <?php echo e(__('inventory.modal.confirm')); ?>

                </button>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .pagination-link {
            @apply inline-block px-2.5 py-1 mx-0.5 border border-[var(--color-sap-blue-light)] rounded text-[var(--color-sap-blue-light)] no-underline cursor-pointer text-sm;
        }

        .pagination-link:hover:not(.active) {
            @apply bg-blue-50;
        }

        .pagination-link.active {
            @apply bg-[var(--color-sap-blue-light)] text-white pointer-events-none;
        }

        .sortable {
            @apply cursor-pointer relative pr-6;
        }

        .sortable::after {
            content: '\2195';
            @apply absolute right-2 top-1/2 -translate-y-1/2 text-sm text-gray-500;
        }

        .sortable.asc::after {
            content: '\2191';
            @apply text-[var(--color-sap-blue-light)];
        }

        .sortable.desc::after {
            content: '\2193';
            @apply text-[var(--color-sap-blue-light)];
        }

        .editable {
            @apply bg-yellow-100 cursor-text;
        }

        .editable:hover {
            @apply bg-yellow-200;
        }

        .editable:focus {
            @apply outline outline-2 outline-[var(--color-sap-blue-light)] bg-white;
        }

        .edit-btn {
            @apply bg-yellow-400 text-black border-0 rounded px-2 py-1 cursor-pointer text-xs mr-1;
        }

        .edit-btn:hover {
            @apply bg-yellow-500;
        }

        .delete-btn {
            @apply bg-red-600 text-white border-0 rounded px-2 py-1 cursor-pointer text-xs;
        }

        .delete-btn:hover {
            @apply bg-red-700;
        }

        .status-reservado {
            @apply bg-yellow-100 text-yellow-800 font-bold px-2 py-1 rounded;
        }

        .status-disponible {
            @apply bg-green-100 text-green-800 px-1.5 py-0.5 rounded;
        }

        .status-despachado {
            @apply bg-blue-100 text-blue-800 px-1.5 py-0.5 rounded;
        }

        .status-cell {
            @apply whitespace-nowrap max-w-xs overflow-hidden text-ellipsis;
        }

        .data-table {
            @apply w-full text-sm;
        }

        .data-table thead {
            @apply bg-[var(--color-sap-table-header)] sticky top-0;
        }

        .data-table th {
            @apply px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs border-t-0;
        }

        .data-table td {
            @apply px-3 py-2 text-xs align-middle border-b border-gray-100;
        }

        .data-table tbody tr:hover {
            @apply bg-[var(--color-sap-table-hover)];
        }

        /* Multiselect Dropdown Styles */
        .multiselect-wrapper {
            position: relative;
        }
        .multiselect-button {
            display: flex;
            justify-content: space-between;
            align-items: center;
            text-align: left;
            cursor: pointer;
            background: white;
        }
        .multiselect-button:hover {
            background: #f8f9fa;
        }
        .multiselect-dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            z-index: 1000;
            max-height: 300px;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        .multiselect-header {
            display: flex;
            justify-content: space-between;
            padding: 8px;
            border-bottom: 1px solid #dee2e6;
            background: #f8f9fa;
        }
        .multiselect-header button {
            font-size: 12px;
            padding: 2px 8px;
        }
        .multiselect-search {
            padding: 8px;
            border-bottom: 1px solid #dee2e6;
        }
        .multiselect-options {
            overflow-y: auto;
            max-height: 200px;
            padding: 4px;
        }
        .multiselect-option {
            display: flex;
            align-items: center;
            padding: 6px 8px;
            cursor: pointer;
            border-radius: 4px;
        }
        .multiselect-option:hover {
            background: #e9ecef;
        }
        .multiselect-option input {
            margin-right: 8px;
        }
        .multiselect-text {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            flex: 1;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php
    $displayColumnsConfig = [
        ['id' => 'cadena', 'header' => __('inventory.table.headers.brand'), 'sortable' => true],
        ['id' => 'campana', 'header' => __('inventory.table.headers.season'), 'sortable' => true],
        [
            'id' => 'ubicacion',
            'header' => __('inventory.table.headers.location'),
            'sortable' => true,
            'editable' => true,
        ],
        ['id' => 'n_carton', 'header' => __('inventory.table.headers.box'), 'sortable' => true],
        ['id' => 'seccion', 'header' => __('inventory.table.headers.section'), 'sortable' => true],
        [
            'id' => 'familia_articulo_description',
            'header' => __('inventory.table.headers.description'),
            'sortable' => true,
        ],
        [
            'id' => 'famillie_usuario',
            'header' => __('inventory.table.headers.family'),
            'sortable' => true,
            'editable' => true,
        ],
        [
            'id' => 'detail_usuario',
            'header' => __('inventory.table.headers.detail'),
            'sortable' => true,
            'editable' => true,
        ],
        ['id' => 'full_barcode', 'header' => __('inventory.table.headers.barcode'), 'sortable' => true],
        ['id' => 'mocaco', 'header' => __('inventory.table.headers.mocaco'), 'sortable' => true],
        [
            'id' => 'season_int',
            'header' => __('inventory.table.headers.season_it'),
            'sortable' => true,
            'editable' => true,
        ],
        ['id' => 'notes', 'header' => __('inventory.table.headers.notes'), 'sortable' => true, 'editable' => true],
        [
            'id' => 'categoria_seleccionada',
            'header' => __('inventory.table.headers.category'),
            'sortable' => true,
            'editable' => true,
        ],
        ['id' => 'conteneur', 'header' => __('inventory.table.headers.container'), 'sortable' => true],
        ['id' => 'status_display', 'header' => __('inventory.table.headers.status'), 'sortable' => true],
        ['id' => 'cliente', 'header' => __('inventory.table.headers.client'), 'sortable' => true],
        ['id' => 'pedido_id', 'header' => __('inventory.table.headers.order_id'), 'sortable' => true],
        ['id' => 'actions', 'header' => __('inventory.table.headers.actions'), 'sortable' => false],
    ];

    $inventoryTexts = [
        'loading' => __('inventory.messages.loading'),
        'initial' => __('inventory.results.initial_message'),
        'no_results' => __('inventory.messages.no_results'),
        'search_error' => __('inventory.messages.search_error'),
        'server_error' => __('inventory.messages.server_error'),
        'found' => __('inventory.messages.found', ['count' => ':count', 'total' => ':total']),
        'update_success' => __('inventory.messages.update_success'),
        'update_error' => __('inventory.messages.update_error', ['message' => ':message']),
        'delete_success' => __('inventory.messages.delete_success'),
        'delete_error' => __('inventory.messages.delete_error', ['message' => ':message']),
        'pagination_info' => __('inventory.pagination.info', [
            'current' => ':current',
            'total' => ':total',
            'records' => ':records',
        ]),
        'results_empty' => __('inventory.results.empty_message'),
    ];
?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // Permisos del usuario para verificar en JavaScript
        const userPermissions = {
            canUpdate: <?php echo json_encode(auth()->user()->can('inventory.update'), 15, 512) ?>,
            canDelete: <?php echo json_encode(auth()->user()->can('inventory.delete'), 15, 512) ?>,
        };

        const displayColumns = <?php echo json_encode($displayColumnsConfig, 15, 512) ?>;
        const inventoryTexts = <?php echo json_encode($inventoryTexts, 15, 512) ?>;

        document.addEventListener('DOMContentLoaded', function() {
            const searchBarcode = document.getElementById('search_barcode');
            const searchMocaco = document.getElementById('search_mocaco');
            const searchNCarton = document.getElementById('search_n_carton');
            const searchUbicacion = document.getElementById('search_ubicacion');
            const searchMarcas = document.getElementById('search_marcas');
            const searchForm = document.getElementById('search-form');
            const searchMessageDiv = document.getElementById('search_message');
            const inventorySearchResults = document.getElementById('inventory_search_results');
            const itemsPerPageSelect = document.getElementById('items_per_page');
            const prevPageBtn = document.getElementById('prev_page_btn');
            const nextPageBtn = document.getElementById('next_page_btn');
            const pageNumbersSpan = document.getElementById('page_numbers');
            const paginationInfoDiv = document.getElementById('pagination_info');

            let currentPage = 1;
            let itemsPerPage = parseInt(itemsPerPageSelect.value);
            let totalRecords = 0;
            let currentSortColumn = null;
            let currentSortDirection = 'asc';
            let lastFetchedResults = [];
            let itemToDelete = null;

            // Multiselect state
            let selectedContainers = [];
            let selectedSeasons = [];
            let allContainers = [];
            let allSeasons = [];

            const editableColumns = displayColumns.filter(col => col.editable).map(col => col.id);

            function formatMessage(template, replacements = {}) {
                return template.replace(/:([a-zA-Z_]+)/g, (match, key) => {
                    return Object.prototype.hasOwnProperty.call(replacements, key) ? replacements[key] :
                        match;
                });
            }

            function showSearchMessage(msg, type) {
                searchMessageDiv.textContent = msg;
                searchMessageDiv.className = `alert alert-${type}`;
                searchMessageDiv.style.display = 'block';
                setTimeout(() => {
                    searchMessageDiv.style.display = 'none';
                }, 3000);
            }

            function updatePaginationControls() {
                const totalPages = Math.ceil(totalRecords / itemsPerPage);
                prevPageBtn.disabled = currentPage === 1;
                nextPageBtn.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersSpan.innerHTML = '';
                if (totalPages > 0) {
                    let startPage = Math.max(1, currentPage - 2);
                    let endPage = Math.min(totalPages, currentPage + 2);

                    if (currentPage <= 3 && totalPages > 5) {
                        endPage = 5;
                    } else if (currentPage >= totalPages - 2 && totalPages > 5) {
                        startPage = totalPages - 4;
                    }

                    for (let i = startPage; i <= endPage; i++) {
                        const pageLink = document.createElement('a');
                        pageLink.href = '#';
                        pageLink.textContent = i;
                        pageLink.classList.add('pagination-link');
                        if (i === currentPage) {
                            pageLink.classList.add('active');
                        }
                        pageLink.addEventListener('click', (e) => {
                            e.preventDefault();
                            if (currentPage !== i) {
                                currentPage = i;
                                performSearch();
                            }
                        });
                        pageNumbersSpan.appendChild(pageLink);
                    }
                }
                paginationInfoDiv.textContent =
                    `Página ${totalPages === 0 ? 0 : currentPage} de ${totalPages} (${totalRecords} registros)`;
            }

            async function performSearch() {
                inventorySearchResults.innerHTML =
                    `<p class="text-center text-muted p-4">${inventoryTexts.loading}</p>`;

                const searchParams = {
                    barcode: searchBarcode.value.trim(),
                    mocaco: searchMocaco.value.trim(),
                    n_carton: searchNCarton.value.trim(),
                    ubicacion: searchUbicacion.value.trim(),
                    marcas: searchMarcas.value.trim(),
                    containers: selectedContainers.length > 0 ? selectedContainers : undefined,
                    seasons: selectedSeasons.length > 0 ? selectedSeasons : undefined,
                    needs_review: document.getElementById('search_needs_review').checked ? true : undefined,
                    page: currentPage,
                    limit: itemsPerPage
                };

                try {
                    const response = await fetch('/inventory/search', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify(searchParams)
                    });

                    const data = await response.json();

                    if (data.success) {
                        totalRecords = data.totalRecords || 0;
                        updatePaginationControls();

                        if (data.results.length > 0) {
                            lastFetchedResults = data.results;

                            if (currentSortColumn) {
                                sortResults(currentSortColumn, currentSortDirection);
                            }

                            renderTable(lastFetchedResults);
                            showSearchMessage(formatMessage(inventoryTexts.found, {
                                count: data.results.length,
                                total: totalRecords
                            }), 'success');
                        } else {
                            inventorySearchResults.innerHTML =
                                `<p class="text-center text-muted p-4">${inventoryTexts.results_empty}</p>`;
                            showSearchMessage(inventoryTexts.no_results, 'danger');
                            lastFetchedResults = [];
                        }
                    } else {
                        inventorySearchResults.innerHTML =
                            `<p class="text-center text-muted p-4">${inventoryTexts.search_error}</p>`;
                        showSearchMessage(data.message || inventoryTexts.search_error, 'danger');
                        lastFetchedResults = [];
                    }
                } catch (error) {
                    console.error('Error de comunicación:', error);
                    showSearchMessage(inventoryTexts.server_error, 'danger');
                    lastFetchedResults = [];
                }
            }

            function renderTable(results) {
                let tableHtml = '<div class="table-responsive"><table class="data-table"><thead><tr>';
                displayColumns.forEach(col => {
                    const isSortable = col.sortable ? 'sortable' : '';
                    let sortClass = '';
                    if (col.id === currentSortColumn) {
                        sortClass = currentSortDirection;
                    }
                    tableHtml +=
                        `<th data-column-id="${col.id}" class="${isSortable} ${sortClass}">${col.header}</th>`;
                });
                tableHtml += '</tr></thead><tbody>';

                results.forEach(itemData => {
                    tableHtml += `<tr data-id="${itemData.id}">`;
                    displayColumns.forEach(col => {
                        let cellValue = itemData[col.id];
                        // Solo hacer editable si el usuario tiene permiso de actualizar
                        let isEditable = (editableColumns.includes(col.id) && userPermissions
                            .canUpdate) ? 'contenteditable="true" class="editable"' : '';
                        let dataCol = col.id;

                        if (col.id === 'actions') {
                            let actionsHtml = '';
                            if (userPermissions.canUpdate) {
                                actionsHtml +=
                                    `<button class="edit-btn" data-id="${itemData.id}" title="Editar">✏️</button> `;
                            }
                            if (userPermissions.canDelete) {
                                actionsHtml +=
                                    `<button class="delete-btn" data-id="${itemData.id}">X</button>`;
                            }
                            tableHtml += `<td>${actionsHtml || '-'}</td>`;
                        } else if (col.id === 'status_display') {
                            // Status con estilos especiales
                            if (cellValue === undefined || cellValue === null || cellValue === '') {
                                cellValue = '';
                            }
                            let statusClass = 'status-cell';
                            if (cellValue && cellValue.toLowerCase().includes('reservado')) {
                                statusClass += ' status-reservado';
                            } else if (cellValue && cellValue.toLowerCase().includes(
                                    'disponible')) {
                                statusClass += ' status-disponible';
                            } else if (cellValue && cellValue.toLowerCase().includes(
                                    'despachado')) {
                                statusClass += ' status-despachado';
                            } else if (cellValue && (cellValue.toLowerCase() === 'order_proposal' || cellValue === 'Propuesta de pedido')) {
                                cellValue = 'Propuesta de pedido';
                                statusClass += ' status-reservado'; // Reusing reserved style or create a new one
                            }
                            tableHtml +=
                                `<td data-col="${dataCol}" class="${statusClass}" title="${cellValue}">${cellValue}</td>`;
                        } else if (col.id === 'pedido_id') {
                            // ID Pedido como enlace si tiene valor
                            if (cellValue === undefined || cellValue === null || cellValue === '') {
                                tableHtml += `<td data-col="${dataCol}">-</td>`;
                            } else {
                                tableHtml +=
                                    `<td data-col="${dataCol}"><a href="/orders/${cellValue}" target="_blank" style="color: #007bff; text-decoration: none;">#${cellValue}</a></td>`;
                            }
                        } else {
                            if (cellValue === undefined || cellValue === null || cellValue === '') {
                                cellValue = '';
                            }
                            tableHtml +=
                                `<td data-col="${dataCol}" ${isEditable}>${cellValue}</td>`;
                        }
                    });
                    tableHtml += '</tr>';
                });

                tableHtml += '</tbody></table></div>';
                inventorySearchResults.innerHTML = tableHtml;

                attachEditListeners();
                attachSortListeners();
                attachDeleteListeners();
                attachEditButtonListeners();
            }

            function attachEditListeners() {
                const editableCells = inventorySearchResults.querySelectorAll('td[contenteditable="true"]');
                editableCells.forEach(cell => {
                    cell.removeEventListener('blur', handleCellEdit);
                    cell.removeEventListener('keydown', handleCellKeydown);
                    cell.addEventListener('blur', handleCellEdit);
                    cell.addEventListener('keydown', handleCellKeydown);
                });
            }

            function handleCellKeydown(event) {
                if (event.key === 'Enter') {
                    event.preventDefault();
                    event.target.blur();
                }
            }

            async function handleCellEdit(event) {
                const cell = event.target;
                const newValue = cell.textContent.trim();
                const itemId = cell.closest('tr').dataset.id;
                const columnToUpdate = cell.dataset.col;

                if (!itemId || !columnToUpdate) {
                    console.error("No se pudo identificar la fila o columna para actualizar.");
                    return;
                }

                const originalItem = lastFetchedResults.find(item => item.id == itemId);
                const originalValue = originalItem ? originalItem[columnToUpdate] : null;

                if (newValue === String(originalValue || '')) {
                    return;
                }

                try {
                    const response = await fetch('/inventory/update-field', {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            id: itemId,
                            column: columnToUpdate,
                            value: newValue
                        })
                    });

                    const data = await response.json();

                    if (data.success) {
                        showSearchMessage(inventoryTexts.update_success, 'success');
                        const updatedItemIndex = lastFetchedResults.findIndex(item => item.id == itemId);
                        if (updatedItemIndex !== -1) {
                            lastFetchedResults[updatedItemIndex][columnToUpdate] = newValue;
                        }
                    } else {
                        showSearchMessage(formatMessage(inventoryTexts.update_error, {
                            message: data.message || ''
                        }), 'danger');
                        if (originalItem) {
                            cell.textContent = originalValue;
                        }
                    }
                } catch (error) {
                    console.error('Error de comunicación al actualizar:', error);
                    showSearchMessage(inventoryTexts.server_error, 'danger');
                    if (originalItem) {
                        cell.textContent = originalValue;
                    }
                }
            }

            function attachSortListeners() {
                const sortableHeaders = inventorySearchResults.querySelectorAll('th.sortable');
                sortableHeaders.forEach(header => {
                    header.removeEventListener('click', handleHeaderClick);
                    header.addEventListener('click', handleHeaderClick);
                });
            }

            function handleHeaderClick(event) {
                const columnId = event.currentTarget.dataset.columnId;
                if (currentSortColumn === columnId) {
                    currentSortDirection = currentSortDirection === 'asc' ? 'desc' : 'asc';
                } else {
                    currentSortColumn = columnId;
                    currentSortDirection = 'asc';
                }
                sortResults(currentSortColumn, currentSortDirection);
                renderTable(lastFetchedResults);
            }

            function sortResults(column, direction) {
                lastFetchedResults.sort((a, b) => {
                    let valA = a[column];
                    let valB = b[column];

                    if (valA === null || valA === undefined || valA === '') {
                        valA = (direction === 'asc') ? Infinity : -Infinity;
                    }
                    if (valB === null || valB === undefined || valB === '') {
                        valB = (direction === 'asc') ? Infinity : -Infinity;
                    }

                    const numA = parseFloat(valA);
                    const numB = parseFloat(valB);

                    if (!isNaN(numA) && !isNaN(numB) && isFinite(numA) && isFinite(numB)) {
                        return direction === 'asc' ? numA - numB : numB - numA;
                    } else {
                        const strA = String(valA).toLowerCase();
                        const strB = String(valB).toLowerCase();
                        if (strA < strB) return direction === 'asc' ? -1 : 1;
                        if (strA > strB) return direction === 'asc' ? 1 : -1;
                        return 0;
                    }
                });

                document.querySelectorAll('th.sortable').forEach(th => {
                    th.classList.remove('asc', 'desc');
                    if (th.dataset.columnId === column) {
                        th.classList.add(direction);
                    }
                });
            }

            function attachEditButtonListeners() {
                const editButtons = inventorySearchResults.querySelectorAll('.edit-btn');
                editButtons.forEach(button => {
                    button.removeEventListener('click', handleEditButtonClick);
                    button.addEventListener('click', handleEditButtonClick);
                });
            }

            function handleEditButtonClick(event) {
                const recordId = event.target.dataset.id;
                if (recordId) {
                    window.location.href = `/inventory/${recordId}/edit`;
                }
            }

            function attachDeleteListeners() {
                const deleteButtons = inventorySearchResults.querySelectorAll('.delete-btn');
                deleteButtons.forEach(button => {
                    button.removeEventListener('click', handleDeleteClick);
                    button.addEventListener('click', handleDeleteClick);
                });
            }

            async function handleDeleteClick(event) {
                const recordId = event.target.dataset.id;
                if (!recordId) {
                    showSearchMessage(inventoryTexts.server_error, 'danger');
                    return;
                }

                document.getElementById('deleteModal').style.display = 'flex';
                itemToDelete = recordId;
            }

            document.getElementById('confirm_delete').addEventListener('click', async () => {
                //const secretCode = document.getElementById('secret_code_input').value;
                //if (secretCode !== '1234') {
                //    showSearchMessage("Código secreto incorrecto.", 'danger');
                //    return;
                //}

                try {
                    const response = await fetch('/inventory/delete', {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            id: itemToDelete
                        })
                    });

                    const data = await response.json();

                    if (data.success) {
                        showSearchMessage(inventoryTexts.delete_success, 'success');
                        document.getElementById('deleteModal').style.display = 'none';
                        //  document.getElementById('secret_code_input').value = '';
                        itemToDelete = null;
                        performSearch();
                    } else {
                        showSearchMessage(formatMessage(inventoryTexts.delete_error, {
                            message: data.message || ''
                        }), 'danger');
                    }
                } catch (error) {
                    console.error('Error de comunicación al eliminar:', error);
                    showSearchMessage(inventoryTexts.server_error, 'danger');
                }
            });

            document.getElementById('cancel_delete').addEventListener('click', () => {
                document.getElementById('deleteModal').style.display = 'none';
                // document.getElementById('secret_code_input').value = '';
                itemToDelete = null;
            });

            searchForm.addEventListener('submit', (e) => {
                e.preventDefault();
                currentPage = 1;
                performSearch();
            });

            itemsPerPageSelect.addEventListener('change', () => {
                itemsPerPage = parseInt(itemsPerPageSelect.value);
                currentPage = 1;
                performSearch();
            });

            prevPageBtn.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    performSearch();
                }
            });

            nextPageBtn.addEventListener('click', () => {
                const totalPages = Math.ceil(totalRecords / itemsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    performSearch();
                }
            });

            // Evento para exportar por marca
            const exportBrandBtn = document.getElementById('export-brand-btn');
            if (exportBrandBtn) {
                exportBrandBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    const brand = searchMarcas.value.trim();
                    if (!brand) {
                        alert('Por favor, ingresa una Marca en el filtro para poder exportar.');
                        searchMarcas.focus();
                        return;
                    }
                    window.location.href = "<?php echo e(route('inventory.export-by-brand')); ?>?brand=" +
                        encodeURIComponent(brand);
                });
            }

            // Carga inicial
            // Initialize multiselect dropdowns
            async function loadFilterOptions() {
                try {
                    const response = await fetch('/api/inventory/filter-options');
                    const data = await response.json();
                    if (data.success) {
                        allContainers = data.containers || [];
                        allSeasons = data.seasons || [];
                        renderMultiselectOptions('containers', allContainers);
                        renderMultiselectOptions('seasons', allSeasons);
                    }
                } catch (error) {
                    console.error('Error loading filter options:', error);
                }
            }

            function renderMultiselectOptions(type, options, filter = '') {
                const container = document.getElementById(`search_${type}_options`);
                const selected = type === 'containers' ? selectedContainers : selectedSeasons;
                const filterLower = filter.toLowerCase();

                const filteredOptions = options.filter(opt =>
                    !filter || opt.toLowerCase().includes(filterLower)
                );

                if (filteredOptions.length === 0) {
                    container.innerHTML = '<div class="text-muted text-center p-2">Sin resultados</div>';
                    return;
                }

                container.innerHTML = filteredOptions.map(opt => `
                    <label class="multiselect-option">
                        <input type="checkbox" value="${opt}" ${selected.includes(opt) ? 'checked' : ''}>
                        <span>${opt}</span>
                    </label>
                `).join('');

                // Attach change listeners
                container.querySelectorAll('input[type="checkbox"]').forEach(cb => {
                    cb.addEventListener('change', () => {
                        if (cb.checked) {
                            if (type === 'containers') {
                                selectedContainers.push(cb.value);
                            } else {
                                selectedSeasons.push(cb.value);
                            }
                        } else {
                            if (type === 'containers') {
                                selectedContainers = selectedContainers.filter(v => v !== cb.value);
                            } else {
                                selectedSeasons = selectedSeasons.filter(v => v !== cb.value);
                            }
                        }
                        updateMultiselectButtonText(type);
                    });
                });
            }

            function updateMultiselectButtonText(type) {
                const btn = document.getElementById(`search_${type}_btn`);
                const selected = type === 'containers' ? selectedContainers : selectedSeasons;
                const textSpan = btn.querySelector('.multiselect-text');
                if (selected.length === 0) {
                    textSpan.textContent = 'Seleccionar...';
                } else if (selected.length === 1) {
                    textSpan.textContent = selected[0];
                } else {
                    textSpan.textContent = `${selected.length} seleccionados`;
                }
            }

            // Toggle dropdowns
            ['containers', 'seasons'].forEach(type => {
                const btn = document.getElementById(`search_${type}_btn`);
                const dropdown = document.getElementById(`search_${type}_dropdown`);

                btn.addEventListener('click', () => {
                    const isVisible = dropdown.style.display !== 'none';
                    // Close all dropdowns first
                    document.querySelectorAll('.multiselect-dropdown').forEach(d => d.style.display = 'none');
                    if (!isVisible) {
                        dropdown.style.display = 'flex';
                    }
                });

                // Select all
                document.getElementById(`${type}_select_all`).addEventListener('click', () => {
                    const options = type === 'containers' ? allContainers : allSeasons;
                    if (type === 'containers') {
                        selectedContainers = [...options];
                    } else {
                        selectedSeasons = [...options];
                    }
                    renderMultiselectOptions(type, options);
                    updateMultiselectButtonText(type);
                });

                // Clear
                document.getElementById(`${type}_clear`).addEventListener('click', () => {
                    if (type === 'containers') {
                        selectedContainers = [];
                    } else {
                        selectedSeasons = [];
                    }
                    renderMultiselectOptions(type, type === 'containers' ? allContainers : allSeasons);
                    updateMultiselectButtonText(type);
                });

                // Search input
                document.getElementById(`${type}_search_input`).addEventListener('input', (e) => {
                    const options = type === 'containers' ? allContainers : allSeasons;
                    renderMultiselectOptions(type, options, e.target.value);
                });
            });

            // Close dropdowns on click outside
            document.addEventListener('click', (e) => {
                if (!e.target.closest('.multiselect-wrapper')) {
                    document.querySelectorAll('.multiselect-dropdown').forEach(d => d.style.display = 'none');
                }
            });

            loadFilterOptions();
            performSearch();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/inventory/index.blade.php ENDPATH**/ ?>