<?php $__env->startSection('title', __('dashboard.title')); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-6">
    <h2 class="text-2xl font-semibold text-[var(--color-sap-text-dark)]">
        <i class="fas fa-tachometer-alt mr-2"></i> <?php echo e(__('dashboard.dashboard')); ?>

    </h2>
    <div class="text-gray-500">
        <i class="fas fa-calendar mr-1"></i> <?php echo e(now()->format('d/m/Y H:i')); ?>

    </div>
</div>

<!-- Estadísticas principales -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-6">
    <div class="bg-white rounded-lg p-5 shadow-[var(--shadow-light)] flex items-center transition-transform hover:-translate-y-0.5">
        <div class="w-15 h-15 rounded-full bg-gradient-to-br from-[var(--color-sap-blue-light)] to-[var(--color-sap-blue-hover)] flex items-center justify-center mr-4 text-white text-2xl">
            <i class="fas fa-boxes"></i>
        </div>
        <div>
            <h3 class="text-3xl font-bold text-[var(--color-sap-blue-dark)] leading-none"><?php echo e($stats['total_items'] ?? 0); ?></h3>
            <p class="text-[var(--color-sap-text-medium)] mt-1 text-sm"><?php echo e(__('dashboard.stats.total_items')); ?></p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-5 shadow-[var(--shadow-light)] flex items-center transition-transform hover:-translate-y-0.5">
        <div class="w-15 h-15 rounded-full bg-gradient-to-br from-[var(--color-sap-blue-light)] to-[var(--color-sap-blue-hover)] flex items-center justify-center mr-4 text-white text-2xl">
            <i class="fas fa-archive"></i>
        </div>
        <div>
            <h3 class="text-3xl font-bold text-[var(--color-sap-blue-dark)] leading-none"><?php echo e($stats['total_boxes'] ?? 0); ?></h3>
            <p class="text-[var(--color-sap-text-medium)] mt-1 text-sm"><?php echo e(__('dashboard.stats.total_boxes')); ?></p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-5 shadow-[var(--shadow-light)] flex items-center transition-transform hover:-translate-y-0.5">
        <div class="w-15 h-15 rounded-full bg-gradient-to-br from-[var(--color-sap-blue-light)] to-[var(--color-sap-blue-hover)] flex items-center justify-center mr-4 text-white text-2xl">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div>
            <h3 class="text-3xl font-bold text-[var(--color-sap-blue-dark)] leading-none"><?php echo e($stats['total_orders'] ?? 0); ?></h3>
            <p class="text-[var(--color-sap-text-medium)] mt-1 text-sm"><?php echo e(__('dashboard.stats.total_orders')); ?></p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-5 shadow-[var(--color-sap-blue-light)] flex items-center transition-transform hover:-translate-y-0.5">
        <div class="w-15 h-15 rounded-full bg-gradient-to-br from-[var(--color-sap-blue-light)] to-[var(--color-sap-blue-hover)] flex items-center justify-center mr-4 text-white text-2xl">
            <i class="fas fa-handshake"></i>
        </div>
        <div>
            <h3 class="text-3xl font-bold text-[var(--color-sap-blue-dark)] leading-none"><?php echo e($stats['total_clients'] ?? 0); ?></h3>
            <p class="text-[var(--color-sap-text-medium)] mt-1 text-sm"><?php echo e(__('dashboard.stats.total_clients')); ?></p>
        </div>
    </div>
</div>

<!-- Acciones rápidas -->
<div class="bg-white rounded-lg shadow-[var(--shadow-light)] mb-6">
    <div class="px-6 py-4 border-b border-gray-200">
        <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
            <i class="fas fa-bolt mr-2"></i> <?php echo e(__('dashboard.quick_actions.title')); ?>

        </h5>
    </div>
    <div class="p-6">
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
            <a href="<?php echo e(route('inventory.create')); ?>" class="flex flex-col items-center p-5 rounded-lg transition-all border-2 border-transparent hover:border-[var(--color-sap-blue-light)] hover:-translate-y-0.5 hover:shadow-md">
                <i class="fas fa-plus-circle text-4xl mb-2 text-[var(--color-sap-blue-light)]"></i>
                <span class="font-medium text-sm text-center"><?php echo e(__('dashboard.quick_actions.add_item')); ?></span>
            </a>

            <a href="<?php echo e(route('scanner')); ?>" class="flex flex-col items-center p-5 rounded-lg transition-all border-2 border-transparent hover:border-[var(--color-sap-blue-light)] hover:-translate-y-0.5 hover:shadow-md">
                <i class="fas fa-barcode text-4xl mb-2 text-[var(--color-sap-blue-light)]"></i>
                <span class="font-medium text-sm text-center"><?php echo e(__('dashboard.quick_actions.scan')); ?></span>
            </a>

            <a href="<?php echo e(route('order-preparation')); ?>" class="flex flex-col items-center p-5 rounded-lg transition-all border-2 border-transparent hover:border-[var(--color-sap-blue-light)] hover:-translate-y-0.5 hover:shadow-md">
                <i class="fas fa-shopping-cart text-4xl mb-2 text-[var(--color-sap-blue-light)]"></i>
                <span class="font-medium text-sm text-center"><?php echo e(__('dashboard.quick_actions.prepare_order')); ?></span>
            </a>

            <a href="<?php echo e(route('location')); ?>" class="flex flex-col items-center p-5 rounded-lg transition-all border-2 border-transparent hover:border-[var(--color-sap-blue-light)] hover:-translate-y-0.5 hover:shadow-md">
                <i class="fas fa-map-marker-alt text-4xl mb-2 text-[var(--color-sap-blue-light)]"></i>
                <span class="font-medium text-sm text-center"><?php echo e(__('dashboard.quick_actions.assign_location')); ?></span>
            </a>

            <a href="<?php echo e(route('client-history')); ?>" class="flex flex-col items-center p-5 rounded-lg transition-all border-2 border-transparent hover:border-[var(--color-sap-blue-light)] hover:-translate-y-0.5 hover:shadow-md">
                <i class="fas fa-history text-4xl mb-2 text-[var(--color-sap-blue-light)]"></i>
                <span class="font-medium text-sm text-center"><?php echo e(__('dashboard.quick_actions.client_history')); ?></span>
            </a>

            <a href="<?php echo e(route('relabeling.create')); ?>" class="flex flex-col items-center p-5 rounded-lg transition-all border-2 border-transparent hover:border-[var(--color-sap-blue-light)] hover:-translate-y-0.5 hover:shadow-md">
                <i class="fas fa-redo text-4xl mb-2 text-[var(--color-sap-blue-light)]"></i>
                <span class="font-medium text-sm text-center"><?php echo e(__('dashboard.quick_actions.relabel')); ?></span>
            </a>
        </div>
    </div>
</div>

<!-- Tablas de resumen -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <!-- Items recientes -->
    <div class="bg-white rounded-lg shadow-[var(--shadow-light)]">
        <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
            <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
                <i class="fas fa-clock mr-2"></i> <?php echo e(__('dashboard.recent_items.title')); ?>

            </h5>
            <a href="<?php echo e(route('inventory.index')); ?>" class="text-sm px-3 py-1 bg-[var(--color-sap-blue-light)] text-white rounded hover:bg-[var(--color-sap-blue-hover)] transition-colors">
                <?php echo e(__('dashboard.recent_items.view_all')); ?>

            </a>
        </div>
        <div class="p-6">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($recent_items) && $recent_items->count() > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-[var(--color-sap-table-header)]">
                            <tr>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.recent_items.code')); ?></th>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.recent_items.mocaco')); ?></th>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.recent_items.box')); ?></th>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.recent_items.date')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $recent_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b border-gray-100 hover:bg-[var(--color-sap-table-hover)]">
                                    <td class="px-3 py-2"><code class="bg-gray-100 px-2 py-1 rounded text-xs"><?php echo e($item->full_barcode); ?></code></td>
                                    <td class="px-3 py-2"><?php echo e($item->mocaco); ?></td>
                                    <td class="px-3 py-2"><?php echo e($item->n_carton); ?></td>
                                    <td class="px-3 py-2"><?php echo e($item->created_at->format('d/m H:i')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <i class="fas fa-box-open text-4xl text-gray-300 mb-3"></i>
                    <p class="text-gray-500"><?php echo e(__('dashboard.recent_items.no_items')); ?></p>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

    <!-- Pedidos pendientes -->
    <div class="bg-white rounded-lg shadow-[var(--shadow-light)]">
        <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
            <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
                <i class="fas fa-list-alt mr-2"></i> <?php echo e(__('dashboard.pending_orders.title')); ?>

            </h5>
            <a href="<?php echo e(route('orders.index')); ?>" class="text-sm px-3 py-1 bg-[var(--color-sap-blue-light)] text-white rounded hover:bg-[var(--color-sap-blue-hover)] transition-colors">
                <?php echo e(__('dashboard.pending_orders.view_all')); ?>

            </a>
        </div>
        <div class="p-6">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($pending_orders) && $pending_orders->count() > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-[var(--color-sap-table-header)]">
                            <tr>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.pending_orders.id')); ?></th>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.pending_orders.client')); ?></th>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.pending_orders.status')); ?></th>
                                <th class="px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs"><?php echo e(__('dashboard.pending_orders.date')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b border-gray-100 hover:bg-[var(--color-sap-table-hover)]">
                                    <td class="px-3 py-2"><?php echo e($order->id); ?></td>
                                    <td class="px-3 py-2"><?php echo e($order->client->name ?? 'N/A'); ?></td>
                                    <td class="px-3 py-2">
                                        <?php
                                            $statusTranslations = [
                                                'draft' => __('orders.status.draft'),
                                                'reserved' => __('orders.status.reserved'),
                                                'pending' => __('orders.status.pending'),
                                                'dispatched' => __('orders.status.dispatched'),
                                                'cancelled' => __('orders.status.cancelled'),
                                            ];
                                            $statusText = $statusTranslations[$order->status] ?? ucfirst($order->status);
                                        ?>
                                        <span class="px-2 py-1 rounded text-xs font-medium <?php echo e($order->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800'); ?>">
                                            <?php echo e($statusText); ?>

                                        </span>
                                    </td>
                                    <td class="px-3 py-2"><?php echo e($order->created_at->format('d/m H:i')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <i class="fas fa-clipboard-list text-4xl text-gray-300 mb-3"></i>
                    <p class="text-gray-500"><?php echo e(__('dashboard.pending_orders.no_orders')); ?></p>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/dashboard.blade.php ENDPATH**/ ?>