<?php $__env->startSection('title', __('order_preparation.title')); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-box-open"></i> <?php echo e(__('order_preparation.subtitle')); ?></h2>
    <div class="d-flex gap-2">
        <a href="<?php echo e(route('reservations.index')); ?>" class="btn btn-outline-primary">
            <i class="fas fa-clipboard-list"></i> Ver Todas las Reservas
        </a>
        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> <?php echo e(__('order_preparation.back')); ?>

        </a>
    </div>
</div>

<!-- Sistema de Pestañas -->
<ul class="nav nav-tabs mb-4" id="orderPrepTabs" role="tablist">
    <!-- Tab 1: Nuevo Pedido (Scan to Order) -->
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="new-order-tab" data-bs-toggle="tab" data-bs-target="#new-order" type="button" role="tab" aria-controls="new-order" aria-selected="true">
            <i class="fas fa-plus"></i> <?php echo e(__('order_preparation.create_order')); ?>

        </button>
    </li>

    <!-- Tab 2: Reservas de Cajas (NUEVO - Box Reservations) -->
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="box-reservations-tab" data-bs-toggle="tab" data-bs-target="#box-reservations" type="button" role="tab" aria-controls="box-reservations" aria-selected="false">
            <i class="fas fa-boxes"></i> Reservas de Cajas
            <span id="pending-reservations-badge" class="badge bg-danger rounded-pill d-none">0</span>
        </button>
    </li>

    <!-- Tab 3: Pedidos Reservados (Antiguo confirmación de pedidos) -->
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="reserved-orders-tab" data-bs-toggle="tab" data-bs-target="#reserved-orders" type="button" role="tab" aria-controls="reserved-orders" aria-selected="false">
            <i class="fas fa-clipboard-check"></i> Pedidos Reservados
        </button>
    </li>
</ul>

<div class="tab-content" id="orderPrepTabsContent">

    <!-- CONTENIDO TAB 1: NUEVO PEDIDO -->
    <div class="tab-pane fade show active" id="new-order" role="tabpanel" aria-labelledby="new-order-tab">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('order-preparation-manager');

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-962903330-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>

    <!-- CONTENIDO TAB 2: RESERVAS DE CAJAS (BOX RESERVATIONS Implementation) -->
    <div class="tab-pane fade" id="box-reservations" role="tabpanel" aria-labelledby="box-reservations-tab">
                        </button>
                        <div>
                            <span class="text-muted me-2 small" id="br_completion_status">Faltan cajas para completar</span>
                            <button type="button" id="br_complete_btn" class="btn btn-success btn-lg" disabled>
                                <i class="fas fa-check-double"></i> Completar y Generar Pedido
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CONTENIDO TAB 3: PEDIDOS RESERVADOS (RESERVED ORDERS Implementation) -->
    <div class="tab-pane fade" id="reserved-orders" role="tabpanel" aria-labelledby="reserved-orders-tab">
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.message {
    padding: 12px;
    margin-bottom: 15px;
    border-radius: 4px;
    font-weight: bold;
    display: block;
    text-align: center;
    font-size: 0.9em;
}

.message.success {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.message.error {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.message.info {
    background-color: #d1ecf1;
    color: #0c5460;
    border: 1px solid #bee5eb;
}

.box-item {
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    padding: 8px 12px;
    margin-bottom: 5px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.box-item .remove-box {
    color: #dc3545;
    cursor: pointer;
    font-size: 1.2em;
}

.box-item .remove-box:hover {
    color: #c82333;
}

.draft-item {
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    padding: 10px;
    margin-bottom: 8px;
}

.draft-item h6 {
    margin-bottom: 5px;
    color: #495057;
}

.draft-item small {
    color: #6c757d;
}

.gap-2 {
    gap: 10px;
}

/* Styles for Box Reservation */
.br-box-item {
    padding: 10px;
    border-bottom: 1px solid #dee2e6;
    transition: background-color 0.2s;
}
.br-box-item:hover {
    background-color: #f1f3f5;
}
.br-box-item.confirmed {
    background-color: #d4edda;
    border-left: 4px solid #28a745;
}
.br-box-item.pending {
    border-left: 4px solid #ffc107;
}
.br-box-status {
    font-size: 0.8em;
    font-weight: bold;
    text-transform: uppercase;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php
$orderPreparationTranslations = [
    'select_client_placeholder' => __('order_preparation.select_client_placeholder'),
    'select_client_option' => __('order_preparation.select_client_option'),
    'no_clients' => __('order_preparation.no_clients'),
    'scan_to_start' => __('order_preparation.scan_to_start'),
    'save_draft' => __('order_preparation.save_draft'),
    'save_draft_with_boxes' => __('order_preparation.save_draft_with_boxes'),
    'saving' => __('order_preparation.saving'),
    'box_already_added' => __('order_preparation.messages.box_already_added'),
    'box_not_exists' => __('order_preparation.messages.box_not_exists'),
    'box_added' => __('order_preparation.messages.box_added'),
    'box_removed' => __('order_preparation.messages.box_removed'),
    'no_boxes' => __('order_preparation.messages.no_boxes'),
    'saving_draft' => __('order_preparation.messages.saving_draft'),
    'draft_saved' => __('order_preparation.messages.draft_saved'),
    'error' => __('order_preparation.messages.error'),
    'request_error' => __('order_preparation.messages.request_error'),
    'network_error' => __('order_preparation.messages.network_error'),
    'validation_error' => __('order_preparation.messages.validation_error'),
    'remove_box_title' => __('order_preparation.remove_box_title'),
    'loading_drafts' => __('order_preparation.loading_drafts'),
    'no_recent_drafts' => __('order_preparation.no_recent_drafts'),
    'error_loading_drafts' => __('order_preparation.error_loading_drafts'),
    'order' => __('order_preparation.order'),
    'client' => __('order_preparation.client'),
    'date' => __('order_preparation.date'),
    'operator' => __('order_preparation.operator'),
];
?>

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
// Inyectar traducciones en JavaScript
const translations = JSON.parse('<?php echo addslashes(json_encode($orderPreparationTranslations)); ?>');

// Función helper para formatear mensajes con parámetros
function formatMessage(key, params = {}) {
    let message = translations[key] || key;
    Object.keys(params).forEach(param => {
        message = message.replace(`:${param}`, params[param]);
    });
    return message;
}

document.addEventListener('DOMContentLoaded', function() {

    // ==========================================
    // LOGICA TAB 1: NUEVO PEDIDO
    // ==========================================
    // Esta lógica ha sido migrada a Livewire (OrderPreparationManager)


    // ==========================================
    // LOGICA TAB 2: RESERVAS DE CAJAS
    // ==========================================
    // Esta lógica ha sido migrada a Livewire (BoxReservationManager)


    // ==========================================
    // Actualizar lista de cajas escaneadas
    function updateScannedBoxesList() {
        const scannedList = document.getElementById('scanned_boxes_list');
        if (scannedReservedBoxes.size === 0) {
            scannedList.innerHTML = '<p class="text-muted text-center mb-0">Aún no se han escaneado cajas</p>';
            return;
        }

        scannedList.innerHTML = '';
        Array.from(scannedReservedBoxes).forEach(box => {
            const div = document.createElement('div');
            div.className = 'badge bg-success me-2 mb-2';
            div.textContent = box;
            scannedList.appendChild(div);
        });
    }

    // Actualizar visualización de cajas reservadas (marcar las escaneadas)
    function updateReservedBoxesDisplay() {
        reservedBoxes.forEach(box => {
            const element = document.getElementById(`reserved-box-${box}`);
            if (element) {
                if (scannedReservedBoxes.has(box)) {
                    element.className = 'badge bg-success me-2 mb-2';
                } else {
                    element.className = 'badge bg-secondary me-2 mb-2';
                }
            }
        });
    }

    // Actualizar lista de cajas extra
    function updateExtraBoxesList() {
        const extraList = document.getElementById('extra_boxes_list').querySelector('.border');
        if (extraBoxes.size === 0) {
            document.getElementById('extra_boxes_list').style.display = 'none';
            return;
        }

        document.getElementById('extra_boxes_list').style.display = 'block';
        extraList.innerHTML = '';
        Array.from(extraBoxes).forEach(box => {
            const div = document.createElement('div');
            div.className = 'badge bg-warning text-dark me-2 mb-2';
            div.textContent = box;
            const removeBtn = document.createElement('span');
            removeBtn.className = 'ms-2 cursor-pointer';
            removeBtn.innerHTML = '×';
            removeBtn.style.cursor = 'pointer';
            removeBtn.onclick = () => {
                extraBoxes.delete(box);
                updateExtraBoxesList();
            };
            div.appendChild(removeBtn);
            extraList.appendChild(div);
        });
    }

    // Actualizar estado del botón de confirmar
    function updateConfirmReservedButton() {
        const allScanned = reservedBoxes.every(box => scannedReservedBoxes.has(box));
        confirmReservedOrderBtn.disabled = !allScanned || scannedReservedBoxes.size === 0;
    }

    // Mostrar mensaje
    function showReservedMessage(message, type) {
        const messageDiv = document.getElementById('reserved_order_message');
        messageDiv.textContent = message;
        messageDiv.className = `message ${type}`;
        messageDiv.style.display = 'block';
        setTimeout(() => {
            messageDiv.style.display = 'none';
        }, 3000);
    }

    // Confirmar pedido reservado
    confirmReservedOrderBtn.addEventListener('click', async () => {
        if (!currentReservedOrder) return;

        const allScanned = reservedBoxes.every(box => scannedReservedBoxes.has(box));
        if (!allScanned) {
            showReservedMessage('Debes escanear todas las cajas reservadas antes de confirmar', 'error');
            return;
        }

        if (!confirm('¿Confirmar y despachar este pedido reservado? Esta acción no se puede deshacer.')) {
            return;
        }

        confirmReservedOrderBtn.disabled = true;
        confirmReservedOrderBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Confirmando...';

        try {
            const response = await fetch('/api/order-preparation/confirm-reserved-order', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    order_id: currentReservedOrder.id,
                    scanned_boxes: Array.from(scannedReservedBoxes),
                    extra_boxes: Array.from(extraBoxes)
                })
            });

            const data = await response.json();

            if (data.success) {
                showReservedMessage(data.message, 'success');
                setTimeout(() => {
                    location.reload();
                }, 2000);
            } else {
                showReservedMessage(data.message || 'Error al confirmar el pedido', 'error');
                confirmReservedOrderBtn.disabled = false;
                confirmReservedOrderBtn.innerHTML = '<i class="fas fa-check"></i> Confirmar y Despachar Pedido';
            }
        } catch (error) {
            console.error('Error al confirmar pedido:', error);
            showReservedMessage('Error de comunicación al confirmar el pedido', 'error');
            confirmReservedOrderBtn.disabled = false;
            confirmReservedOrderBtn.innerHTML = '<i class="fas fa-check"></i> Confirmar y Despachar Pedido';
        }
    });

    // Cancelar confirmación de pedido reservado
    cancelReservedOrderBtn.addEventListener('click', () => {
        reservedOrderInfo.style.display = 'none';
        currentReservedOrder = null;
        reservedBoxes = [];
        scannedReservedBoxes.clear();
        extraBoxes.clear();
        reservedOrderSelect.value = '';
        loadReservedOrderBtn.disabled = true;
    });

    // Cargar pedidos reservados al iniciar
    loadReservedOrders();
});

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/order-preparation/index.blade.php ENDPATH**/ ?>