<?php $__env->startSection('title', __('reports.stock_summary.title')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-4">
    <div>
        <h1 class="page-title mb-1"><?php echo e(__('reports.stock_summary.header')); ?></h1>
        <p class="text-muted mb-0">
            <?php echo e(__('reports.stock_summary.description')); ?>

        </p>
    </div>
</div>

<div class="card mb-4 shadow-sm">
    <div class="card-header">
        <h5 class="mb-0"><i class="fas fa-filter me-2"></i><?php echo e(__('reports.stock_summary.filters.title')); ?></h5>
    </div>
    <form method="GET" action="<?php echo e(route('reports.stock-summary')); ?>">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="marca" class="form-label"><?php echo e(__('reports.stock_summary.filters.brand')); ?></label>
                    <input type="text" id="marca" name="marca" class="form-control"
                           value="<?php echo e($filters['marca']); ?>">
                </div>
                <div class="col-md-3">
                    <label for="season_int" class="form-label"><?php echo e(__('reports.stock_summary.filters.season_internal')); ?></label>
                    <input type="text" id="season_int" name="season_int" class="form-control"
                           value="<?php echo e($filters['season_int']); ?>">
                </div>
                <div class="col-md-3">
                    <label for="season" class="form-label"><?php echo e(__('reports.stock_summary.filters.season')); ?></label>
                    <input type="text" id="season" name="season" class="form-control"
                           value="<?php echo e($filters['season']); ?>">
                </div>
                <div class="col-md-3">
                    <label for="status_scope" class="form-label"><?php echo e(__('reports.stock_summary.filters.status_scope')); ?></label>
                    <select id="status_scope" name="status_scope" class="form-select">
                        <option value="all" <?php echo e($filters['status_scope'] === 'all' ? 'selected' : ''); ?>><?php echo e(__('reports.stock_summary.filters.status_all')); ?></option>
                        <option value="trabajada" <?php echo e($filters['status_scope'] === 'trabajada' ? 'selected' : ''); ?>><?php echo e(__('reports.stock_summary.filters.status_worked')); ?></option>
                        <option value="sin_trabajar" <?php echo e($filters['status_scope'] === 'sin_trabajar' ? 'selected' : ''); ?>><?php echo e(__('reports.stock_summary.filters.status_pending')); ?></option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search me-1"></i> <?php echo e(__('reports.stock_summary.filters.apply')); ?>

            </button>
            <a href="<?php echo e(route('reports.stock-summary')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-undo me-1"></i> <?php echo e(__('reports.common.clear')); ?>

            </a>
        </div>
    </form>
</div>

<?php
    $totalTrabajada = $totals->total_trabajada ?? 0;
    $totalSinTrabajar = $totals->total_sin_trabajar ?? 0;
    $totalMercancia = $totals->total_mercancia ?? 0;
?>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="metric-card bg-light border h-100 p-3 rounded">
            <div class="text-muted text-uppercase small"><?php echo e(__('reports.stock_summary.metrics.worked')); ?></div>
            <div class="display-6 fw-bold text-success"><?php echo e(number_format($totalTrabajada)); ?></div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="metric-card bg-light border h-100 p-3 rounded">
            <div class="text-muted text-uppercase small"><?php echo e(__('reports.stock_summary.metrics.pending')); ?></div>
            <div class="display-6 fw-bold text-warning"><?php echo e(number_format($totalSinTrabajar)); ?></div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="metric-card bg-light border h-100 p-3 rounded">
            <div class="text-muted text-uppercase small"><?php echo e(__('reports.stock_summary.metrics.total')); ?></div>
            <div class="display-6 fw-bold text-primary"><?php echo e(number_format($totalMercancia)); ?></div>
        </div>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i><?php echo e(__('reports.stock_summary.details.title')); ?></h5>
        <span class="text-muted"><?php echo e(__('reports.stock_summary.details.count', ['count' => $summary->count()])); ?></span>
    </div>
    <div class="card-body p-0">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($summary->isEmpty()): ?>
            <div class="p-4 text-center text-muted">
                <i class="fas fa-info-circle me-2"></i><?php echo e(__('reports.stock_summary.details.empty')); ?>

            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th><?php echo e(__('reports.stock_summary.details.headers.brand')); ?></th>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $seasonInts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seasonInt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th class="text-center"><?php echo e($seasonInt); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <th class="text-center"><?php echo e(__('reports.stock_summary.details.headers.pending')); ?></th>
                            <th class="text-center"><?php echo e(__('reports.stock_summary.details.headers.total')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $summary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($row['marca'] ?? __('reports.stock_summary.details.no_brand')); ?></strong></td>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $seasonInts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seasonInt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td class="text-center">
                                        <?php echo e(isset($row['season_ints'][$seasonInt]) ? number_format($row['season_ints'][$seasonInt]['cantidad']) : '0'); ?>

                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <td class="text-center fw-semibold text-warning"><?php echo e(number_format($row['total_sin_trabajar'])); ?></td>
                                <td class="text-center fw-bold text-primary"><?php echo e(number_format($row['total_general'])); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($summary->isNotEmpty()): ?>
                        <tfoot class="table-light">
                            <tr>
                                <td><strong>Total</strong></td>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $seasonInts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seasonInt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $totalSeason = 0;
                                        foreach($summary as $row) {
                                            if (isset($row['season_ints'][$seasonInt])) {
                                                $totalSeason += $row['season_ints'][$seasonInt]['cantidad'];
                                            }
                                        }
                                    ?>
                                    <td class="text-center fw-bold"><?php echo e(number_format($totalSeason)); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <td class="text-center fw-bold text-warning"><?php echo e(number_format($totals->total_sin_trabajar ?? 0)); ?></td>
                                <td class="text-center fw-bold text-primary"><?php echo e(number_format($totals->total_mercancia ?? 0)); ?></td>
                            </tr>
                        </tfoot>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </table>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/reports/stock-summary.blade.php ENDPATH**/ ?>