<?php $__env->startSection('title', 'Cajas Sin Ubicación'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-map-marker-slash"></i> Cajas Sin Ubicación</h2>
        <div class="badge bg-danger" style="font-size: 1.2em;">
            <?php echo e($stats['total_boxes']); ?> cajas | <?php echo e($stats['total_items']); ?> artículos
        </div>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Filtros -->
    <div class="card mb-4">
        <div class="card-header">
            <h5><i class="fas fa-filter"></i> Filtros de Búsqueda</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('inventory.boxes-without-location')); ?>">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Contenedor</label>
                        <input type="text" name="conteneur" class="form-control" value="<?php echo e(request('conteneur')); ?>"
                            placeholder="Ej: CAMION-001">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Número de Caja</label>
                        <input type="text" name="n_carton" class="form-control" value="<?php echo e(request('n_carton')); ?>"
                            placeholder="Ej: CAJA-001">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Desde</label>
                        <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Hasta</label>
                        <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                    </div>
                </div>
                <div class="mt-3">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i> Buscar</button>
                    <a href="<?php echo e(route('inventory.boxes-without-location')); ?>" class="btn btn-secondary"><i
                            class="fas fa-times"></i> Limpiar</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Lista de Cajas -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5><i class="fas fa-box-open"></i> Cajas Sin Ubicación Asignada</h5>
            <span class="badge bg-warning text-dark"><?php echo e($boxes->total()); ?> resultados</span>
        </div>
        <div class="card-body">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($boxes->count() > 0): ?>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i> <strong>Atención:</strong> Estas cajas necesitan ser
                    asignadas a una ubicación para mantener el control del inventario.
                </div>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Número de Caja</th>
                                <th>Contenedor</th>
                                <th>Total Artículos</th>
                                <th>Primer Escaneo</th>
                                <th>Último Escaneo</th>
                                <th>Operarios</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $boxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><code><?php echo e($box->n_carton); ?></code></td>
                                    <td><?php echo e($box->conteneur); ?></td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($box->total_items); ?> artículos</span>
                                    </td>
                                    <td><?php echo e(\Carbon\Carbon::parse($box->first_scan)->format('d/m/Y H:i')); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($box->last_scan)->format('d/m/Y H:i')); ?></td>
                                    <td>
                                        <small><?php echo e(Str::limit($box->operators, 30)); ?></small>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('location')); ?>?n_carton=<?php echo e($box->n_carton); ?>"
                                            class="btn btn-sm btn-success" title="Asignar Ubicación">
                                            <i class="fas fa-map-marker-alt"></i> Asignar
                                        </a>
                                        <a href="<?php echo e(route('inventory.index')); ?>?n_carton=<?php echo e($box->n_carton); ?>"
                                            class="btn btn-sm btn-primary" title="Ver Contenido">
                                            <i class="fas fa-eye"></i> Ver
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    <?php echo e($boxes->links()); ?>

                </div>
            <?php else: ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> ¡Excelente! No hay cajas sin ubicación asignada.
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

    <!-- Estadísticas Adicionales -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($boxes->count() > 0): ?>
        <div class="card mt-4">
            <div class="card-header">
                <h5><i class="fas fa-chart-bar"></i> Resumen</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-md-6">
                        <div class="p-3 bg-light rounded">
                            <h3 class="text-danger"><?php echo e($stats['total_boxes']); ?></h3>
                            <p class="mb-0">Cajas sin ubicación</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="p-3 bg-light rounded">
                            <h3 class="text-warning"><?php echo e($stats['total_items']); ?></h3>
                            <p class="mb-0">Artículos afectados</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/inventory/boxes-without-location.blade.php ENDPATH**/ ?>