<?php $__env->startSection('title', __('orders.title')); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-6">
    <h2 class="text-2xl font-semibold text-[var(--color-sap-text-dark)]">
        <i class="fas fa-shopping-cart mr-2"></i> <?php echo e(__('orders.title')); ?>

    </h2>
    <div class="flex gap-2">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.view')): ?>
        <a href="<?php echo e(route('orders.export')); ?>?<?php echo e(request()->getQueryString()); ?>"
           class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-700 transition-colors text-sm">
            <i class="fas fa-file-excel mr-2"></i> <?php echo e(__('orders.buttons.export_excel')); ?>

        </a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.create')): ?>
        <a href="<?php echo e(route('orders.create')); ?>"
           class="inline-flex items-center px-4 py-2 bg-[var(--color-sap-blue-light)] text-white rounded hover:bg-[var(--color-sap-blue-hover)] transition-colors text-sm">
            <i class="fas fa-plus mr-2"></i> <?php echo e(__('orders.buttons.new_order')); ?>

        </a>
        <?php endif; ?>
    </div>
</div>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('import_summary')): ?>
    <?php $summary = session('import_summary'); ?>
    <div class="mb-4 p-4 bg-blue-50 border border-blue-200 text-blue-800 rounded">
        <strong><?php echo e(__('orders.import.summary_title')); ?></strong>
        <?php echo e($summary['reserved_boxes']); ?> <?php echo e(__('orders.import.reserved_boxes')); ?> (<?php echo e($summary['reserved_units']); ?> <?php echo e(__('orders.import.reserved_units')); ?>) <?php echo e(__('orders.import.reserved')); ?>.
        <?php echo e(__('orders.import.orders_created')); ?>: <?php echo e($summary['orders_created']); ?>, <?php echo e(__('orders.import.orders_used')); ?>: <?php echo e($summary['orders_used']); ?>.
        <?php echo e(__('orders.import.processed_rows')); ?>: <?php echo e($summary['processed_rows']); ?>, <?php echo e(__('orders.import.skipped_rows')); ?>: <?php echo e($summary['skipped_rows']); ?>.
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($summary['errors'])): ?>
            <details class="mt-2">
                <summary class="cursor-pointer font-semibold"><?php echo e(__('orders.import.view_details')); ?> (<?php echo e(count($summary['errors'])); ?> <?php echo e(__('orders.import.errors')); ?>)</summary>
                <ul class="mb-0 mt-2 pl-5">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $summary['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>
            </details>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<!-- Filtros -->
<div class="bg-white rounded-lg shadow-[var(--shadow-light)] mb-4">
    <div class="px-6 py-4 border-b border-gray-200">
        <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
            <i class="fas fa-filter mr-2"></i> <?php echo e(__('orders.filters.title')); ?>

        </h5>
    </div>
    <div class="p-6">
        <form method="GET" action="<?php echo e(route('orders.index')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1"><?php echo e(__('orders.filters.search')); ?></label>
                <input type="text"
                       class="w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-[var(--color-sap-blue-light)] text-sm"
                       id="search"
                       name="search"
                       value="<?php echo e(request('search')); ?>"
                       placeholder="<?php echo e(__('orders.filters.search_placeholder')); ?>">
            </div>
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1"><?php echo e(__('orders.filters.status')); ?></label>
                <select class="w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-[var(--color-sap-blue-light)] text-sm"
                        id="status"
                        name="status">
                    <option value=""><?php echo e(__('orders.filters.status_all')); ?></option>
                    <option value="draft" <?php echo e(request('status') === 'draft' ? 'selected' : ''); ?>><?php echo e(__('orders.status.draft')); ?></option>
                    <option value="reserved" <?php echo e(request('status') === 'reserved' ? 'selected' : ''); ?>><?php echo e(__('orders.status.reserved')); ?></option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>><?php echo e(__('orders.status.pending')); ?></option>
                    <option value="dispatched" <?php echo e(request('status') === 'dispatched' ? 'selected' : ''); ?>><?php echo e(__('orders.status.dispatched')); ?></option>
                    <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>><?php echo e(__('orders.status.cancelled')); ?></option>
                </select>
            </div>
            <div>
                <label for="client_id" class="block text-sm font-medium text-gray-700 mb-1"><?php echo e(__('orders.filters.client')); ?></label>
                <select class="w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-[var(--color-sap-blue-light)] text-sm"
                        id="client_id"
                        name="client_id">
                    <option value=""><?php echo e(__('orders.filters.client_all')); ?></option>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($client->id); ?>" <?php echo e(request('client_id') == $client->id ? 'selected' : ''); ?>>
                            <?php echo e($client->client_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">&nbsp;</label>
                <div class="flex gap-2">
                    <button type="submit"
                            class="px-4 py-2 bg-[var(--color-sap-blue-light)] text-white rounded hover:bg-[var(--color-sap-blue-hover)] transition-colors text-sm">
                        <i class="fas fa-search mr-2"></i> <?php echo e(__('orders.filters.apply')); ?>

                    </button>
                    <a href="<?php echo e(route('orders.index')); ?>"
                       class="px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-700 transition-colors text-sm">
                        <i class="fas fa-times mr-2"></i> <?php echo e(__('orders.filters.clear')); ?>

                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.create')): ?>
<div class="bg-white rounded-lg shadow-[var(--shadow-light)] mb-4">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
            <i class="fas fa-file-upload mr-2"></i> <?php echo e(__('orders.import.title')); ?>

        </h5>
        <div class="flex gap-2 items-center">
            <small class="text-gray-500"><?php echo e(__('orders.import.description')); ?></small>
            <a href="<?php echo e(route('orders.reservations-template')); ?>"
               class="px-3 py-1 text-xs border border-gray-400 text-gray-600 rounded hover:bg-gray-100 transition-colors">
                <i class="fas fa-download mr-1"></i> <?php echo e(__('orders.import.download_template')); ?>

            </a>
        </div>
    </div>
    <div class="p-6">
        <form action="<?php echo e(route('orders.import-reservations')); ?>" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-4 items-end">
            <?php echo csrf_field(); ?>
            <div>
                <label for="reservations_file" class="block text-sm font-medium text-gray-700 mb-1"><?php echo e(__('orders.import.file_label')); ?></label>
                <input type="file"
                       class="w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-[var(--color-sap-blue-light)] text-sm"
                       id="reservations_file"
                       name="reservations_file"
                       accept=".xlsx,.xls,.csv"
                       required>
            </div>
            <div>
                <button type="submit"
                        class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 transition-colors text-sm">
                    <i class="fas fa-upload mr-2"></i> <?php echo e(__('orders.import.process')); ?>

                </button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>

<!-- Tabla de Pedidos -->
<div class="bg-white rounded-lg shadow-[var(--shadow-light)]">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h5 class="font-semibold text-lg text-[var(--color-sap-text-dark)]">
            <i class="fas fa-list mr-2"></i> <?php echo e(__('orders.title')); ?>

        </h5>
        <span class="px-3 py-1 bg-[var(--color-sap-blue-light)] text-white rounded text-sm font-medium">
            <?php echo e($orders->total()); ?> <?php echo e(__('orders.table.total_orders')); ?>

        </span>
    </div>
    <div class="p-0">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($orders->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('orders.table.id')); ?></th>
                            <th><?php echo e(__('orders.table.client')); ?></th>
                            <th><?php echo e(__('orders.table.status')); ?></th>
                            <th><?php echo e(__('orders.table.operator')); ?></th>
                            <th><?php echo e(__('orders.table.date')); ?></th>
                            <th><?php echo e(__('orders.table.actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($order->id); ?></td>
                                <td><?php echo e($order->client->client_name ?? 'N/A'); ?></td>
                                <td>
                                    <?php
                                        $statusClasses = [
                                            'dispatched' => 'bg-green-100 text-green-800',
                                            'cancelled' => 'bg-red-100 text-red-800',
                                            'pending' => 'bg-blue-100 text-blue-800',
                                            'reserved' => 'bg-cyan-100 text-cyan-800',
                                            'draft' => 'bg-yellow-100 text-yellow-800',
                                        ];
                                        $statusClass = $statusClasses[$order->status] ?? 'bg-gray-100 text-gray-800';
                                        $statusTranslations = [
                                            'draft' => __('orders.status.draft'),
                                            'reserved' => __('orders.status.reserved'),
                                            'pending' => __('orders.status.pending'),
                                            'dispatched' => __('orders.status.dispatched'),
                                            'cancelled' => __('orders.status.cancelled'),
                                        ];
                                        $statusText = $statusTranslations[$order->status] ?? ucfirst($order->status);
                                    ?>
                                    <span class="px-2 py-1 rounded text-xs font-medium <?php echo e($statusClass); ?>">
                                        <?php echo e($statusText); ?>

                                    </span>
                                </td>
                                <td><?php echo e($order->operario_id ?? '-'); ?></td>
                                <td><?php echo e($order->created_at->format('d/m/Y H:i')); ?></td>
                                <td>
                                    <div class="flex gap-1">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.view')): ?>
                                        <a href="<?php echo e(route('orders.show', $order)); ?>"
                                           class="px-2 py-1 text-xs border border-blue-500 text-blue-500 rounded hover:bg-blue-500 hover:text-white transition-colors"
                                           title="<?php echo e(__('orders.buttons.view')); ?>">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.update')): ?>
                                        <a href="<?php echo e(route('orders.edit', $order)); ?>"
                                           class="px-2 py-1 text-xs border border-yellow-500 text-yellow-600 rounded hover:bg-yellow-500 hover:text-white transition-colors"
                                           title="<?php echo e(__('orders.buttons.edit')); ?>">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.view')): ?>
                                        <a href="<?php echo e(route('orders.export-order', $order)); ?>"
                                           class="px-2 py-1 text-xs border border-green-500 text-green-600 rounded hover:bg-green-500 hover:text-white transition-colors"
                                           title="<?php echo e(__('orders.buttons.download_excel')); ?>">
                                            <i class="fas fa-file-excel"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.delete')): ?>
                                        <form action="<?php echo e(route('orders.destroy', $order)); ?>"
                                              method="POST"
                                              class="inline"
                                              onsubmit="return confirm('<?php echo e(__('orders.messages.delete_confirm')); ?>')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit"
                                                    class="px-2 py-1 text-xs border border-red-500 text-red-500 rounded hover:bg-red-500 hover:text-white transition-colors"
                                                    title="<?php echo e(__('orders.buttons.delete')); ?>">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="px-6 py-4 border-t border-gray-200">
                <?php echo e($orders->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <i class="fas fa-shopping-cart text-6xl text-gray-300 mb-4"></i>
                <h5 class="text-xl font-semibold text-gray-600 mb-2"><?php echo e(__('orders.messages.no_orders')); ?></h5>
                <p class="text-gray-500 mb-4"><?php echo e(__('orders.messages.no_orders_description')); ?></p>
                <a href="<?php echo e(route('orders.create')); ?>"
                   class="inline-flex items-center px-4 py-2 bg-[var(--color-sap-blue-light)] text-white rounded hover:bg-[var(--color-sap-blue-hover)] transition-colors text-sm">
                    <i class="fas fa-plus mr-2"></i> <?php echo e(__('orders.buttons.create_first')); ?>

                </a>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .data-table {
        @apply w-full text-sm;
    }

    .data-table thead {
        @apply bg-[var(--color-sap-table-header)] sticky top-0;
    }

    .data-table th {
        @apply px-3 py-2 text-left font-semibold text-[var(--color-sap-text-medium)] text-xs border border-gray-200;
    }

    .data-table td {
        @apply px-3 py-2 text-xs align-middle border border-gray-200;
    }

    .data-table tbody tr:nth-child(even) {
        @apply bg-gray-50;
    }

    .data-table tbody tr:hover {
        @apply bg-[var(--color-sap-table-hover)];
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/orders/index.blade.php ENDPATH**/ ?>