#!/bin/bash

# Script de prueba para el sistema de importación optimizado
# Este script demuestra cómo usar el nuevo sistema de importación asíncrona

echo "=========================================="
echo "Test de Importación Optimizada"
echo "=========================================="
echo ""

# Colores para output
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# Directorio del proyecto
PROJECT_DIR="/home/development/projects/inventory/inventory_new"
cd "$PROJECT_DIR"

echo -e "${YELLOW}1. Verificando archivo de prueba...${NC}"
if [ -f "storage/app/test_import_10000.csv" ]; then
    LINES=$(wc -l < storage/app/test_import_10000.csv)
    SIZE=$(du -h storage/app/test_import_10000.csv | cut -f1)
    echo -e "${GREEN}✓ Archivo encontrado: $LINES líneas, $SIZE${NC}"
else
    echo -e "${RED}✗ Archivo no encontrado${NC}"
    exit 1
fi

echo ""
echo -e "${YELLOW}2. Verificando migraciones...${NC}"
php artisan migrate:status | grep -E "(import_progress|add_indexes)" && \
    echo -e "${GREEN}✓ Migraciones aplicadas${NC}" || \
    echo -e "${RED}✗ Ejecuta: php artisan migrate${NC}"

echo ""
echo -e "${YELLOW}3. Verificando tabla de progreso...${NC}"
mysql -u root -p -e "USE inventory_db; DESCRIBE import_progress;" 2>/dev/null && \
    echo -e "${GREEN}✓ Tabla import_progress existe${NC}" || \
    echo -e "${YELLOW}⚠ No se pudo verificar (requiere credenciales MySQL)${NC}"

echo ""
echo -e "${YELLOW}4. Verificando índices...${NC}"
mysql -u root -p -e "USE inventory_db; SHOW INDEX FROM theoretical_articles WHERE Key_name LIKE 'idx_%';" 2>/dev/null && \
    echo -e "${GREEN}✓ Índices creados${NC}" || \
    echo -e "${YELLOW}⚠ No se pudo verificar (requiere credenciales MySQL)${NC}"

echo ""
echo -e "${YELLOW}5. Verificando queue worker...${NC}"
if pgrep -f "queue:work" > /dev/null; then
    echo -e "${GREEN}✓ Queue worker está corriendo${NC}"
    ps aux | grep "queue:work" | grep -v grep
else
    echo -e "${RED}✗ Queue worker NO está corriendo${NC}"
    echo -e "${YELLOW}  Inicia el worker con: php artisan queue:work --tries=3 --timeout=3600${NC}"
fi

echo ""
echo -e "${YELLOW}6. Limpiando trabajos anteriores...${NC}"
php artisan queue:flush 2>/dev/null
echo -e "${GREEN}✓ Cola limpiada${NC}"

echo ""
echo "=========================================="
echo -e "${GREEN}Sistema listo para pruebas${NC}"
echo "=========================================="
echo ""
echo "PASOS PARA PROBAR:"
echo "1. Asegúrate de que el queue worker esté corriendo:"
echo "   php artisan queue:work --tries=3 --timeout=3600"
echo ""
echo "2. Sube el archivo vía interfaz web:"
echo "   - Navega a: http://tu-dominio/container-entries/[ID]"
echo "   - Sube: storage/app/test_import_10000.csv"
echo ""
echo "3. Monitorea el progreso:"
echo "   - En la UI verás el progreso en tiempo real"
echo "   - O usa: curl http://tu-dominio/container-entries/[ID]/import-progress"
echo ""
echo "4. Verifica los resultados:"
echo "   mysql> SELECT COUNT(*) FROM theoretical_articles WHERE container_entry_id = [ID];"
echo "   mysql> SELECT * FROM import_progress ORDER BY id DESC LIMIT 1;"
echo ""
echo "RENDIMIENTO ESPERADO:"
echo "  - 10,000 filas: ~10 segundos"
echo "  - Sin errores de timeout"
echo "  - Progreso actualizado en tiempo real"
echo ""
