<?php

namespace App\Models {

	/**
	 * App\Models\Article
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $grupo_arancelario
	 * @property decimal:3|null $peso_unitario
	 * @property string|null $campana
	 * @property string|null $composition
	 * @property string|null $partida_arancelaria
	 * @property decimal:2|null $precio_pvp_maximo_temporada
	 * @property string|null $mercado_origen_articulo
	 * @property string|null $cadena
	 * @property string|null $familia
	 * @property string|null $seccion
	 * @property string $mocaco
	 * @property int $id
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Inventory> $inventoryItems
	 * @property-read int|null $inventoryItems_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereMocaco($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereSeccion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereFamilia($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereCadena($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereMercadoOrigenArticulo($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article wherePrecioPvpMaximoTemporada($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article wherePartidaArancelaria($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereComposition($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereCampana($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article wherePesoUnitario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereGrupoArancelario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Article>|Article query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Article extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\AuditLog
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $notes
	 * @property string|null $user_agent
	 * @property string|null $ip_address
	 * @property array|null $new_values
	 * @property array|null $old_values
	 * @property int|null $model_id
	 * @property string $model_type
	 * @property string $action
	 * @property int|null $user_id
	 * @property int $id
	 * @property-read \App\Models\User $user
	 * @property-read \App\Models\AuditLog $model
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereAction($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereModelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereModelId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereOldValues($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereNewValues($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereIpAddress($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUserAgent($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereNotes($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class AuditLog extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Client
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property boolean $is_active
	 * @property string|null $address
	 * @property string|null $phone
	 * @property string|null $email
	 * @property string $client_name
	 * @property int $id
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Order> $orders
	 * @property-read int|null $orders_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Order> $historyOrders
	 * @property-read int|null $historyOrders_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereClientName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereEmail($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client wherePhone($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereAddress($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client active()
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Client extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\ContainerEntry
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $notes
	 * @property \Illuminate\Support\Carbon|null $fecha_finalizacion
	 * @property \Illuminate\Support\Carbon|null $fecha_inicio_proceso
	 * @property int|null $usuario_asignado_id
	 * @property \App\Enums\ContainerEntryStatus $estado
	 * @property string|null $tipo_producto
	 * @property string|null $marca
	 * @property string $n_camion
	 * @property int $id
	 * @property-read \App\Models\User $usuarioAsignado
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $usuariosAsignados
	 * @property-read int|null $usuariosAsignados_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\TheoreticalArticle> $theoreticalArticles
	 * @property-read int|null $theoreticalArticles_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AuditLog> $auditLogs
	 * @property-read int|null $auditLogs_count
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereNCamion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereMarca($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereTipoProducto($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereEstado($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereUsuarioAsignadoId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereFechaInicioProceso($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereFechaFinalizacion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereNotes($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry enProceso()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry finalizado()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry byContainer()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContainerEntry>|ContainerEntry query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ContainerEntry extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Inventory
	 *
	 * @property int|null $order_id
	 * @property mixed $status
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property \Illuminate\Support\Carbon $fecha_escaneo
	 * @property string|null $detail_usuario
	 * @property string|null $grupo_arancelario
	 * @property decimal:3|null $peso_unitario
	 * @property string|null $campana
	 * @property string|null $composition
	 * @property string|null $partida_arancelaria
	 * @property decimal:2|null $precio_pvp_maximo_temporada
	 * @property string|null $mercado_origen_articulo
	 * @property string|null $cadena
	 * @property string|null $familia_articulo_description
	 * @property string|null $seccion
	 * @property string|null $famillie_usuario
	 * @property string|null $categoria_seleccionada
	 * @property string|null $ubicacion
	 * @property string|null $n_id_operario
	 * @property string|null $conteneur
	 * @property string|null $notes
	 * @property string|null $season_int
	 * @property string $n_carton
	 * @property string $mocaco
	 * @property string $full_barcode
	 * @property int $id
	 * @property-read \App\Models\Article $article
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\OrderItem> $orderItems
	 * @property-read int|null $orderItems_count
	 * @property-read \App\Models\Order $order
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AuditLog> $auditLogs
	 * @property-read int|null $auditLogs_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereFullBarcode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereMocaco($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereNCarton($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereSeasonInt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereNotes($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereConteneur($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereNIdOperario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereUbicacion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereCategoriaSeleccionada($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereFamillieUsuario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereSeccion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereFamiliaArticuloDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereCadena($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereMercadoOrigenArticulo($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory wherePrecioPvpMaximoTemporada($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory wherePartidaArancelaria($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereComposition($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereCampana($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory wherePesoUnitario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereGrupoArancelario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereDetailUsuario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereFechaEscaneo($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory whereOrderId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory byBox()
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory byMocaco()
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory byContainer()
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory byBarcode()
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Inventory>|Inventory query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Inventory extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Order
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $url_pdf_factura
	 * @property \Illuminate\Support\Carbon|null $dispatched_date
	 * @property \Illuminate\Support\Carbon $order_date
	 * @property mixed $status
	 * @property string|null $notes
	 * @property string|null $operario_id
	 * @property int $user_id
	 * @property int $client_id
	 * @property int $id
	 * @property-read \App\Models\Client $client
	 * @property-read \App\Models\User $user
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\OrderItem> $orderItems
	 * @property-read int|null $orderItems_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AuditLog> $auditLogs
	 * @property-read int|null $auditLogs_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereClientId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereOperarioId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereNotes($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereOrderDate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereDispatchedDate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereUrlPdfFactura($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order draft()
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order pending()
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order dispatched()
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Order>|Order query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Order extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\OrderItem
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string $n_carton
	 * @property string $mocaco
	 * @property string $full_barcode
	 * @property int $inventory_id
	 * @property int $order_id
	 * @property int $id
	 * @property-read \App\Models\Order $order
	 * @property-read \App\Models\Inventory $inventory
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereOrderId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereInventoryId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereFullBarcode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereMocaco($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereNCarton($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<OrderItem>|OrderItem query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class OrderItem extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\RelabelingProduct
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property decimal:2|null $price_cfa
	 * @property string|null $description
	 * @property string|null $codebar_gnu
	 * @property string $proveedor_code
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct whereProveedorCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct whereCodebarGnu($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct wherePriceCfa($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct byProviderCode()
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<RelabelingProduct>|RelabelingProduct query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class RelabelingProduct extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\SystemConfig
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $value
	 * @property string $key
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig whereKey($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig whereValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<SystemConfig>|SystemConfig query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class SystemConfig extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\TheoreticalArticle
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $notes
	 * @property string|null $grupo_arancelario
	 * @property decimal:3|null $peso_unitario
	 * @property string|null $campana
	 * @property string|null $composition
	 * @property string|null $partida_arancelaria
	 * @property decimal:2|null $precio_pvp_maximo_temporada
	 * @property string|null $mercado_origen_articulo
	 * @property string|null $cadena
	 * @property string|null $familia_articulo_description
	 * @property string|null $seccion
	 * @property string|null $detail_usuario
	 * @property string|null $famillie_usuario
	 * @property string|null $categoria_seleccionada
	 * @property string|null $season_int
	 * @property integer $cantidad_unidades
	 * @property string $mocaco
	 * @property int $container_entry_id
	 * @property int $id
	 * @property-read mixed $peso_total
	 * @property-read mixed $precio_total
	 * @property-read \App\Models\ContainerEntry $containerEntry
	 * @property-read \App\Models\Article $article
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereContainerEntryId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereMocaco($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereCantidadUnidades($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereSeasonInt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereCategoriaSeleccionada($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereFamillieUsuario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereDetailUsuario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereSeccion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereFamiliaArticuloDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereCadena($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereMercadoOrigenArticulo($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle wherePrecioPvpMaximoTemporada($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle wherePartidaArancelaria($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereComposition($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereCampana($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle wherePesoUnitario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereGrupoArancelario($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereNotes($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle byContainerEntry()
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle byMocaco()
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TheoreticalArticle>|TheoreticalArticle query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class TheoreticalArticle extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\User
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $remember_token
	 * @property string|null $two_factor_confirmed_at
	 * @property string|null $two_factor_recovery_codes
	 * @property string|null $two_factor_secret
	 * @property string $password
	 * @property \Illuminate\Support\Carbon|null $email_verified_at
	 * @property boolean $is_active
	 * @property int|null $client_id
	 * @property string|null $operario_id
	 * @property string $email
	 * @property string $name
	 * @property int $id
	 * @property-read \App\Models\Client $client
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Order> $orders
	 * @property-read int|null $orders_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AuditLog> $auditLogs
	 * @property-read int|null $auditLogs_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\ContainerEntry> $containerEntries
	 * @property-read int|null $containerEntries_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
	 * @property-read int|null $notifications_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
	 * @property-read int|null $roles_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereOperarioId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereClientId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTwoFactorSecret($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTwoFactorRecoveryCodes($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTwoFactorConfirmedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User active()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User role()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User withoutRole()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User permission()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User withoutPermission()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
	 * @method static mixed orWhereValueBetween($value, array $columns)
	 * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
	 * @method static mixed orWhereValueNotBetween($value, array $columns)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class User extends \Illuminate\Foundation\Auth\User
	{
		//
	}

}